import torch
import argparse


def read_ckpt(ckpt):
    print("\n==> loading checkpoint '{}'\n".format(ckpt))
    status = torch.load(ckpt)
    epoch = status['epoch']
    best_prec1 = status['best_prec1']
    print("epoch: {}      best_prec1: {}".format(epoch, best_prec1))


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--ckpt', type=str, help='dir to the ckpt to be loaded')
    args = parser.parse_args()

    read_ckpt(args.ckpt)

